from sandbox import sdk2
from sandbox.projects.resource_types import AbstractResource
from sandbox.sdk2.helpers import subprocess as sp
import sandbox.common.types.resource as ctr


class AutoBudgetDailyLimitsMonitoringBin(AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ["YABS_AUTOBUDDGET"]
    release_subscribers = ["m-ustinov"]


class AutoBudgetDailyLimitsMonitoring(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 2048
        disk_space = 2048

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        binary_id = sdk2.parameters.LastReleasedResource(
            'Auto budget daily limits monitoring binary',
            resource_type=AutoBudgetDailyLimitsMonitoringBin,
            state=(ctr.State.READY,),
            required=True
        )

        cluster = sdk2.parameters.String('cluster with source table', default='hahn')
        daily_limits_table = sdk2.parameters.String('path to table',
                                                    default='//home/yabs/dict/AutoBudgetOrderDailyValues')
        connect_timeout = sdk2.parameters.Integer('connect to graphite timeout', default=10)
        metric_name = sdk2.parameters.String('graphite metric name', default='one_hour')
        time_precision = sdk2.parameters.Integer('send to graphite time precision in seconds', default=3600)
        yt_token_secret_id = sdk2.parameters.YavSecret("YT token secret id", required=True,
                                                       description='secret should contain keys: token',
                                                       default='sec-01dg9pn791asxk9xpagtqx2q2f')

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.binary_id)
        env = {'YT_TOKEN': self.Parameters.yt_token_secret_id.data()["token"]}
        cmd = [
            str(bin_res.path),
            '--cluster={0}'.format(self.Parameters.cluster),
            '--daily-limits-table={0}'.format(self.Parameters.daily_limits_table),
            '--connect-timeout={0}'.format(self.Parameters.connect_timeout),
            '--metric-name={0}'.format(self.Parameters.metric_name),
            '--time-precision={0}'.format(self.Parameters.time_precision),
        ]
        with sdk2.helpers.ProcessLog(self, logger="ab_daily_limits_mon") as pl:
            sp.check_call(cmd, stdout=pl.stdout, stderr=pl.stderr, env=env)
