from sandbox import sdk2
import sandbox.projects.resource_types as rt
from sandbox.sdk2.helpers import subprocess, ProcessLog


class AutobudgetMlBuildOutput(rt.BUILD_OUTPUT):
    pass


class CpaAutobudgetBinary(rt.ARCADIA_PROJECT):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ["sameg", "serkh", "robot-cpa-ab", "robot-autobudget", "alex-kozinov", "druxa", "dimion", "a-evseev", "adnartsev", "akimov-victor", "stason", "k1noo", "anspiridonov", "coubex", "gmalik", "borzenkoanton"]
    release_subscribers = ["sameg", "serkh"]


class BidderAnalogBinaryPackage(CpaAutobudgetBinary):
    releasers = ["robot-cpa-ab", "dimion"]
    release_subscribers = ["dimion"]


class BidderAnalogConfigPackage(CpaAutobudgetBinary):
    releasers = ["robot-cpa-ab", "dimion"]
    release_subscribers = ["dimion"]


class BidderBinaryPackage(CpaAutobudgetBinary):
    pass


class BidderConfigPackage(CpaAutobudgetBinary):
    releasers = ["robot-cpa-ab"]


class AbCostKpiBinaryPackage(CpaAutobudgetBinary):
    pass


class DebugOrderBinaryPackage(CpaAutobudgetBinary):
    pass


class SimpleYqlScriptsRunnerBinaryPackage(CpaAutobudgetBinary):
    pass


class EquivalencyMonitoringBinaryPackage(CpaAutobudgetBinary):
    pass


class PaidActionsProfitKpiBinaryPackage(CpaAutobudgetBinary):
    pass


class CostForecastBinary(rt.ARCADIA_PROJECT):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ["serkh", "robot-autobudget"]
    release_subscribers = ["serkh"]


class AutobudgetMlBinary(rt.ARCADIA_PROJECT):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ["olegts", "serkh"]
    release_subscribers = ["serkh"]


class AutobudgetMlTask(sdk2.Task):
    @property
    def env(self):
        return {
            'YT_TOKEN': sdk2.Vault.data('robot-autobudget', 'YT_TOKEN'),
            'YQL_TOKEN': sdk2.Vault.data('robot-autobudget', 'YQL_TOKEN'),
        }

    def run_binary_with_args(self, args):
        """
        Run binary with list of arguments.
        self.Parameters must have 'binary_id' attribute
        Each argument is either 'scalar' (int, string etc.) or pair of scalars ('--attr-name', attr_value).

        :param args: list of arguments for binary call
        :return: None
        """

        if not hasattr(self, 'Parameters') or not hasattr(self.Parameters, 'binary_id'):
            raise AttributeError("Attribute 'binary_id' not found in self.Parameters")

        bin_res = sdk2.ResourceData(self.Parameters.binary_id)
        cmd = [str(bin_res.path)]

        for arg in args:
            if type(arg) in (list, tuple):
                if len(arg) != 2:
                    raise ValueError("Iterable arguments must have exactly 2 elements")
                cmd.append('{}={}'.format(*arg))
            else:
                cmd.append(str(arg))

        with ProcessLog(self, logger=self.__class__.__name__) as l:
            subprocess.check_call(cmd, stdout=l.stdout, stderr=l.stderr, env=self.env)
