from sandbox import sdk2
from sandbox.sdk2.parameters import LastReleasedResource, String, Integer
import sandbox.common.types.resource as ctr

from sandbox.projects.autobudget.ml import AutobudgetMlBinary, AutobudgetMlTask


class AutobudgetMlComputeMetricsBinary(AutobudgetMlBinary):
    pass


class AutobudgetMlComputeMetrics(AutobudgetMlTask):
    class Parameters(sdk2.Parameters):
        binary_id = LastReleasedResource(
            "autobudget ml: 'compute_metrics' binary",
            resource_type=AutobudgetMlComputeMetricsBinary,
            state=(ctr.State.READY,),
            required=True
        )

        prediction_logs_regexp = String('Prediction logs regexp (e.g. "autobudget/ml/PredictionLog/PredictionsSearch")',
                                        required=True)
        stat_logs_type = String('Stat logs type (e.g. "JoinedYabarEFHFactors")', required=True)
        stat_logs_n_hours = Integer('Stat logs number of hours to compute predictions', default=1)
        graphite_tag = String('Graphite tag to separate predictions (e.g. "search_default")', required=True)
        # src_cluster = String('YT cluster', default="hahn")

    def on_execute(self):
        args = [
            '--send-to-graphite',
            ('--prediction-logs-regexp', self.Parameters.prediction_logs_regexp),
            ('--stat-logs-type', self.Parameters.stat_logs_type),
            ('--stat-logs-n-hours', self.Parameters.stat_logs_n_hours),
            ('--graphite-tag', self.Parameters.graphite_tag),
        ]
        self.run_binary_with_args(args)
