from sandbox import sdk2
from sandbox.sdk2.parameters import LastReleasedResource, String
import sandbox.common.types.resource as ctr

from sandbox.projects.autobudget.ml import AutobudgetMlBinary, AutobudgetMlTask


class AutobudgetMlDeployPredictionsBinary(AutobudgetMlBinary):
    pass


class AutobudgetMlDeployPredictions(AutobudgetMlTask):
    class Parameters(sdk2.Parameters):
        binary_id = LastReleasedResource(
            "autobudget ml: 'deploy_predictions' binary",
            resource_type=AutobudgetMlDeployPredictionsBinary,
            state=(ctr.State.READY,),
            required=True
        )

        src_cluster = String('Source YT cluster', default="hahn", required=True)
        src_predictions_search = String('Source table with predictions for search (TargetType == 0)', required=True)
        src_predictions_network = String('Source table with predictions for network (TargetType == 3)', required=True)
        dst_cluster = String('Destination YT cluster', required=True)
        dst_table = String('Destination table', required=True)

    def on_execute(self):
        args = [
            ('--src-cluster', self.Parameters.src_cluster),
            ('--src-predictions-search', self.Parameters.src_predictions_search),
            ('--src-predictions-network', self.Parameters.src_predictions_network),
            ('--dst-cluster', self.Parameters.dst_cluster),
            ('--dst-table', self.Parameters.dst_table),
        ]
        self.run_binary_with_args(args)
