import logging

from sandbox import sdk2
from sandbox.sdk2.parameters import Resource, String
import sandbox.common.types.resource as ctr

from sandbox.projects.autobudget.ml import CpaAutobudgetBinary

from sandbox.common import rest
import requests

import os
import stat

class PrepareCpaAutobudgetBinary(sdk2.Task):
    STABLE_SMOOTH_TAG = 'testing'

    class Parameters(sdk2.Parameters):
        binary = Resource(
            "CPA_AUTOBUDGET_BINARY",
            resource_type=CpaAutobudgetBinary,
            state=(ctr.State.READY,),
            required=True
        )


    def on_execute(self):
        src_resource = sdk2.ResourceData(self.Parameters.binary)
        dst_resource = sdk2.ResourceData(CpaAutobudgetBinary(
            self, "Built autobudget/bidder r%s" % self.Parameters.binary.arcadia_revision, "bidder"
        ))
        dst_resource.path.write_bytes(src_resource.path.read_bytes())
        st = os.stat(str(dst_resource.path))
        os.chmod(str(dst_resource.path), st.st_mode | stat.S_IEXEC)
        dst_resource.ready()
        self.set_info("Use '%s' to make smooth stable release" % self.STABLE_SMOOTH_TAG)


    def on_release(self, parameters):
        if parameters.get('release_status').lower() == self.STABLE_SMOOTH_TAG:
            stable = CpaAutobudgetBinary.find(attrs={'released': 'stable'}, order='-id').first()
            stable_smooth = CpaAutobudgetBinary.find(attrs={'released': self.STABLE_SMOOTH_TAG}, order='-id').first()
            if stable_smooth and (stable is None or stable_smooth.created >= stable.created):
                raise Exception('Smooth release of %s is currently in progress' % (stable_smooth.url))
        super(PrepareCpaAutobudgetBinary, self).on_release(parameters)


    @property
    def release_template(self):
        return sdk2.ReleaseTemplate(
            CpaAutobudgetBinary.release_subscribers,
            "Release autobudget/bidder r%s" % self.Parameters.binary.arcadia_revision,
            None,
            ['stable', 'prestable', self.STABLE_SMOOTH_TAG, 'cancelled']
        )
