from sandbox import sdk2
from sandbox.sdk2.parameters import LastReleasedResource, String
import sandbox.common.types.resource as ctr

from sandbox.projects.autobudget.ml import AutobudgetMlBinary, AutobudgetMlTask


class AutobudgetMlPrepareDataBinary(AutobudgetMlBinary):
    pass


class AutobudgetMlPrepareData(AutobudgetMlTask):
    class Parameters(sdk2.Parameters):
        binary_id = LastReleasedResource(
            "autobudget ml: 'prepare_data' binary",
            resource_type=AutobudgetMlPrepareDataBinary,
            state=(ctr.State.READY,),
            required=True
        )

        dst_table = String('Table with features for further prediction', required=True)
        cluster = String('YT cluster', default='hahn')

    def on_execute(self):
        args = [
            ('--dst-table', self.Parameters.dst_table),
            ('--cluster', self.Parameters.cluster),
        ]
        self.run_binary_with_args(args)
