from sandbox import sdk2
from sandbox.sdk2.parameters import LastReleasedResource, String, Integer
import sandbox.common.types.resource as ctr

from sandbox.projects.autobudget.ml import AutobudgetMlBinary, AutobudgetMlTask


class AutobudgetMlPrepareYabsForecastBinary(AutobudgetMlBinary):
    pass


class AutobudgetMlPrepareYabsForecast(AutobudgetMlTask):
    class Parameters(sdk2.Parameters):
        binary_id = LastReleasedResource(
            "autobudget ml: 'prepare_data_yabs_forecast' binary",
            resource_type=AutobudgetMlPrepareYabsForecastBinary,
            state=(ctr.State.READY,),
            required=True
        )

        src_dbrestore_bstat_table = String(
            'Table name from dbrestore/bstat\d+ dumps (i.e. GroupAutoBudgetForecasterAPC)', required=True)
        dst_dir = String('YT destination dir', required=True)
        dst_table_ttl_hours = Integer('TTL (in hours) of prediction tables', default=24*7)

    def on_execute(self):
        args = [
            ('--src-dbrestore-bstat-table', self.Parameters.src_dbrestore_bstat_table),
            ('--dst-dir', self.Parameters.dst_dir),
            ('--dst-table-ttl-hours', self.Parameters.dst_table_ttl_hours),
        ]
        self.run_binary_with_args(args)
