import logging

from sandbox import sdk2
from sandbox.sdk2 import parameters
from sandbox.projects.yabs.base_bin_task import BaseBinTask

logging.basicConfig(level=logging.DEBUG)


class StringList(parameters.List):
    supported_types = (parameters.String,)


class AutobudgetPrepareExperiments(BaseBinTask):
    """
    Prepares tables for Autobudget A/B experiments
    """

    class Parameters(BaseBinTask.Parameters):
        clusters = StringList('Clusters', description='List of YT clusters to prepare experiments in', required=True)
        collectors = StringList('Collectors', description='List of SBYT collectors to lock', required=True)
        tables = StringList('Tables', description='List of YT table names (without path) to copy', required=True)
        root_path = parameters.String('Root path', description='Path to YT folder with autobudget experiments', required=True)
        lock_path = parameters.String('Lock path', description='Path to YT folder with locks for SBYT collectors', required=True)
        schema_path = parameters.String('Schema path', description='YT table with experiments config', required=True)
        force = parameters.Bool('Force', description='Overwrite existing tables while copying', default=False)
        yt_token_vault = parameters.String('YT token', description='Sandbox Vault secret name for YT token', required=True)

    def on_execute(self):
        from yabs.sbyt.prepare_experiments.lib import PrepareExperimentsApp

        app = PrepareExperimentsApp(logger=logging)
        app.run(
            clusters=self.Parameters.clusters,
            collectors=self.Parameters.collectors,
            tables=self.Parameters.tables,
            root_path=self.Parameters.root_path,
            lock_path=self.Parameters.lock_path,
            schema_path=self.Parameters.schema_path,
            force=self.Parameters.force,
            token=sdk2.Vault.data(self.Parameters.yt_token_vault),
        )
