import logging

from sandbox import sdk2
from sandbox.common import errors


DEFAULT_AUTOCHECK_OWNER = 'robot-autocheck'
DEFAULT_YA_TOKEN_NAME = 'YA_TOKEN'
DEFAULT_ARC_TOKEN_NAME = 'ARC_TOKEN'


def _get_token(secret_name, diag, owner):
    try:
        logging.debug('Getting %s oauth token from vault: user=%s, secret_name=%s', diag, owner, secret_name)
        return sdk2.Vault.data(owner, secret_name)
    except errors.VaultError as e:
        raise Exception('Unable to fetch %s oauth token, %s', diag, e)


def get_autocheck_ci_token(owner):
    secret_name = 'autocheck_ci_token'
    return _get_token(secret_name, 'testenv', owner)


def get_logbroker_token(owner):
    secret_name = 'ci_logbroker_token'
    return _get_token(secret_name, secret_name, owner)


def get_ya_bin_token(ya_bin_token_string, owner):
    if not ya_bin_token_string:
        secret_name, secret_owner = DEFAULT_YA_TOKEN_NAME, DEFAULT_AUTOCHECK_OWNER
    elif ':' in ya_bin_token_string:
        secret_name, secret_owner = ya_bin_token_string.split(':')
    else:
        secret_name, secret_owner = ya_bin_token_string, owner
    return _get_token(secret_name, 'ya', secret_owner)


def get_arc_token(arc_token_string, owner):
    if not arc_token_string:
        secret_name, secret_owner = DEFAULT_ARC_TOKEN_NAME, DEFAULT_AUTOCHECK_OWNER
    elif ':' in arc_token_string:
        secret_name, secret_owner = arc_token_string.split(':')
    else:
        secret_name, secret_owner = arc_token_string, owner
    return _get_token(secret_name, 'arc', secret_owner)
