# Автосборочные sandbox задачи

## Конфигурация автосборки
Основные параметры конфигурации автосборки хранятся в файле
[autocheck/autocheck.yaml](https://a.yandex-team.ru/arc/trunk/arcadia/autocheck/autocheck.yaml).
Автосборочной задаче можно указать из какой ревизии брать этот файл через опцию `autocheck_config_revision`.
Если эта опция не проставлена, то `autocheck.yaml` будет загружен из бинаря автосборочной задачи.

## Стадии выполнения автосборочной задачи

Автосборочная задача в зависимости от параметров может запускаться в
нескольких режимах.

### Автосборка 2.0 (прекомиты и посткомиты)

#### Шаг 1
Задача монтирует две аркадии: либо аркадию на ревизии r1 и аркадию на ревизии r2,
либо аркадию с патчем и аркадию без патча

#### Шаг 2
С помощью библиотеки ggass строится контекст, содержащий `сборочный граф разности`

1. Генерируем левый и правый `мета графы` с кэшами и без кэшей(fallback вариант)

`Мета граф с кэшами` содержит 3 ноды:
- ноду скачивания статистических данных для Distbuild-шедулера
- ноду скачивания кэшей ymake
- ноду генерации `сборочного графа` с применением кэшей ymake и стат. данных для Distbuild-шедулера

`Мета граф без кэшей` содержит 1 ноду:
- нода генерации графa **без** применением кэшей ymake и стат. данных для DistBuild-шедулера
Эти графы понадобятся на случай, если не получится скачать или применить либо стат. данных для DistBuild-шедулера, либо кэши ymake.

2. Генерируем два `графа разности` на основе полученных `мета графов` обычный и fallback(без кэшей)
3. Исполняем полученный `граф разности` на дистбилде. Если не удалось по каким-то причинам
исполнить обычный `граф разности`, ты пытаемся исполнить fallback `граф разности`. И роняем исполнение партиции,
если не получилось исполнить fallback граф.
4. В результате исполнения `графа разности` получаем контекст, который
содержит `сборочный граф разности`

#### Шаг 3
Проверяем число измененных нод в `сборочном графе разности`. Если если их число слишком большое, то
задача пессимизируется. После этого исполнение задачи останавливается,
 и задача встает в специальный семафор `pessimized_precommit`, который поднимется только ночью.

#### Шаг 4
Исполняем на дистбилде `сборочный граф разности`. По мере выполнения графа
результаты отсылаются в CI через логброкер.

### Автосборка 1.0 (автосборка в бранчах)
В этом режиме задача из параметров партиции формирует команду сборки `ya make`, которая сама
производит генерацию `сборочного графа` на дистбилде, и последующего его исполнения на дистбилде.
Самый медленный режим, так как собирается полный `сборочный граф` на всю аркадию

### Быстрый контур (Прекомиты)
В этом режиме задача запускается так же, как и в Автосборке 2.0. С одной оптимизацией.
В задачу передают для исполнения не всю аркадию, а конкретные таргеты. Задача
 для каждого таргета фильтрует тулчейны, под которые эти таргеты не запускаются.

### Речек (Прекомиты и посткомиты)
В этом режиме в задачу передается специальный конфиг через опцию `custom_targets_list`.
В нем указан список из `[["path", "toolchain", partition_index, ["test_type", ...]], ... ]`.
Дальше задача выполняется в режиме Автосборка 1.0. То есть формирует из этого конфига команду `ya make`
и исполняет его.

## Ресурс AutocheckLogs
Каждая партиция для хранения логов создает свой ресурс `AutocheckLogs`.
В нем находится:
1. Логи генерации и сами `меты графы`
   - левого графа ggaas_graph_build.tar
   - правого графа ggaas_comparing_repos_state_graph_build.tar
2. Логи генерации и сами `графы разности` и `сборочный граф разности`
   - subtract_on_dist.tar
3. Логи исполнения `сборочного графа разности`
   - log_file.txt.tar
   - event_log_file.json
   - build.err.txt
   - build.out.txt
4. Сообщения переданные в CI
   - results2.json.tar
   - raw_reports.json.tar (только, если данные передавались через sp)
   - reports.json.tar (только, если данные передавались через sp)
5. Стейджи, метрики и т.д.

## Используемые секреты
Автосборочная задача использует токены из sanbox vault:
1. autocheck_ci_token - токен для походов в testenv
2. ci_logbroker_token - токен для отправки данных в CI через логброкер
3. YA_TOKEN робота robot-autocheck@ - токен аунтефикации в ya
4. ARC_TOKEN робота robot-autocheck@ - токен аунтификации в arc

## Используемые sandbox семафоры
Для балансировки нагрузки на дистбилд автосборочная задача в зависимости
от параметров берет следующие семафоры:
1. autocheck_acceptance - для интеграционного тестирования самой автосборочной задачи
2. autocheck_emulation - для нагрузочного тестироания дистбилда
3. precommits_for_fast_check - для задач быстрого контура
4. precommits - для прекомитных задач
6. autocheck - для всех посткомитных задач, производящих сборку
7. precommits_for_arc_branch - для прекомитных задач, запущенных в arc бранчах
8. autocheck_for_arc_branch - для посткомитных задач, запущенных в arc бранчах
9. precommits_for_branch - для прекомитных задач, запущенных в svn бранчах
10. autocheck_for_branch - для посткомитных задач, запущенных в svn бранчах
11. pessimized_precommit - для пессимизированных по нодам задач
