# coding: utf-8
# TODO: Use ggaas/ya_utils instead
#       Don't forget to change it

import json
import logging
import os
import platform
import shutil

from sandbox.common import config
from sandbox.common.types import misc as ctm
from sandbox.sandboxsdk import channel
from sandbox.sandboxsdk.paths import remove_path
from sandbox.sandboxsdk.process import run_process


MISC_DATA_FILES = [
    'evlogdump.json',
    'ymake.conf',
    'test.dart',
]


PYTHON = '/skynet/python/bin/python'


def mine_ya(source_root, ya_binary=None):
    return [ya_binary] if ya_binary else [PYTHON, os.path.join(source_root, 'ya')]


def get_custom_fetcher():
    return None if config.Registry().common.installation == ctm.Installation.LOCAL else str(channel.channel.task.synchrophazotron)


def set_custom_fetcher(env):
    custom_fetcher = get_custom_fetcher()
    if custom_fetcher is not None:
        env['YA_CUSTOM_FETCHER'] = custom_fetcher
    return env


class YaBuilder(object):
    def __init__(self, source_root, build_root, output_dir, ya_binary=None):
        self.logger = logging.getLogger(__name__)
        self.source_root = source_root
        self.build_root = build_root
        self.output_dir = output_dir
        self.ya_cmd = mine_ya(source_root, ya_binary)

    def build(self, ya_options, wait_process, strace=None, log_prefix=None, stdout=None, stderr=None):
        env = os.environ.copy()
        set_custom_fetcher(env)
        command, env_from_options = ya_options.generate()
        self.logger.debug("Some env will be (maybe) update: %s",
                          tuple(sorted(set(env.keys()).intersection(env_from_options.keys())))
                          )
        env.update(env_from_options)
        self.logger.debug('Run ya with env %s', env)
        self.logger.debug('Run build with cmd %s', command)

        if platform.system() == 'Linux' and strace:
            command = ['strace', '-f', '-o', strace] + command

        return run_process(
            command, environment=env, check=False,
            work_dir=self.source_root, log_prefix=log_prefix, stdout=stdout, stderr=stderr,
            wait=wait_process
        )

    def on_build_process_finished(self, returncode):
        if returncode != 0:
            self.cleanup_symlinks(self.output_dir)
        self.copy_misc_data(self.output_dir)

    @staticmethod
    def cleanup_symlinks(directory):
        for dir_name, dir_list, file_list in os.walk(directory):
            for fn in file_list + dir_list:
                file_path = os.path.abspath(os.path.join(directory, dir_name, fn))
                if os.path.islink(file_path):
                    logging.debug('Remove symlink %s', file_path)
                    remove_path(file_path)

    def copy_misc_data(self, to_dir):
        def copy_if_exists(from_path, to_path):
            if os.path.exists(from_path):
                if not os.path.exists(os.path.dirname(to_path)):
                    os.makedirs(os.path.dirname(to_path))
                shutil.copy(from_path, to_path)

        for file_name in MISC_DATA_FILES:
            copy_if_exists(os.path.join(self.build_root, file_name), os.path.join(to_dir, file_name))

    def load_json_file(self, file_name, room=None):
        from library.python import strings
        with open(os.path.join(room or self.output_dir, file_name)) as f:
            return strings.unicodize_deep(json.load(f))

    def get_failed_deps(self):
        return self.load_json_file('failed_dependants.json')

    def get_results2(self):
        return self.load_json_file('results2.json')

    def get_build_errors(self):
        return self.load_json_file('build_errors.json')

    def get_owners_list(self):
        return self.load_json_file('owners_list.json')

    def get_targets(self):
        return self.load_json_file('targets.json')

    def cleanup(self):
        pass
