def get_autocheck_distbuild_priority(distbuild_priority, distbuild_fixed_priority, revision, task_id, is_arc_url):
    from yalibrary.yandex.distbuild import distbs_consts

    class AutocheckDistbuildPriority(object):
        def __init__(self, distbuild_priority, distbuild_fixed_priority, revision, task_id, is_arc_url):
            self.distbuild_priority = distbuild_priority
            self.distbuild_fixed_priority = distbuild_fixed_priority
            self.revision = revision
            self.task_id = task_id
            self.is_arc_url = is_arc_url

        def calc(self, priority_delta=0):
            if self.is_arc_url and self.distbuild_fixed_priority != -1:
                return self.distbuild_fixed_priority
            # if we in arc branch (revision = -1) then priority is based on task id which is higher than revision
            # TODO(rustammm) probably we should use commit time instead
            return distbs_consts.calc_dist_priority(self.distbuild_priority, self.revision if self.revision != -1 else self.task_id, priority_delta)

        @property
        def high_cache_hit(self):
            return self.calc(distbs_consts.DISTBUILD_HIGH_CACHE_HIT_PRIORITY_DELTA)

        @property
        def medium_cache_hit(self):
            return self.calc(distbs_consts.DISTBUILD_MEDIUM_CACHE_HIT_PRIORITY_DELTA)

        @property
        def low_cache_hit(self):
            return self.calc(distbs_consts.DISTBUILD_LOW_CACHE_HIT_PRIORITY_DELTA)

        @property
        def postcommits(self):
            return self.calc(distbs_consts.DISTBUILD_POSTCOMMITS_PRIORITY_DELTA)

        @property
        def large_tests(self):
            return self.calc(distbs_consts.DISTBUILD_LARGE_TESTS_PRIORITY_DELTA)

        @property
        def fast_checks(self):
            return self.calc(distbs_consts.DISTBUILD_FAST_CHECK_PRIORITY_DELTA)

    return AutocheckDistbuildPriority(distbuild_priority, distbuild_fixed_priority, revision, task_id, is_arc_url)
