# -*- coding: utf-8 -*-

import os
import time
import logging

from sandbox import sdk2


PATHS_TO_PACK = [
    'build-statistics',
    'build.err.txt',
    'build.out.txt',
    'compiler-messages',
    'context.work.dir',
    'context.work.dir-fallback',
    'distbs_result.json',
    'distbuild_rpc_log.log',
    'event_log_file.json',
    'log_file.txt',
    'raw_reports.json',
    'reports.json',
    'results2.json',
]

TEST_RESULTS_ROOT = 'build-release'


def pack_and_remove(paths_to_pack, destination=None):
    start_time = time.time()
    logging.info("Packing data from dirs: %s", paths_to_pack)
    packed_paths = []
    for path in paths_to_pack:
        if os.path.exists(path):
            tar_path = (path if destination is None else os.path.join(destination, os.path.basename(path))) + '.tar'
            sdk2.paths.remove_path(tar_path)
            sdk2.helpers.subprocess.run(
                ['tar', '--gzip', '--dereference', '--create', '--ignore-failed-read', '--file', tar_path, os.path.basename(path)],
                cwd=os.path.dirname(path),
            )
            sdk2.paths.remove_path(path)
            packed_paths.append(tar_path)
    logging.info("Data is packed, %s, %f sec", packed_paths, time.time() - start_time)
    return packed_paths


def pack_resources(logs_dir):
    logging.info('Pack files in %s', logs_dir)
    paths_to_pack = [os.path.join(logs_dir, x) for x in PATHS_TO_PACK]
    pack_and_remove(paths_to_pack)

    br_path = os.path.join(logs_dir, TEST_RESULTS_ROOT)
    if os.path.isdir(br_path):
        packed_destination = None
        if os.path.islink(br_path):
            br_link = br_path
            br_path = os.path.realpath(br_path)
            logging.debug('Replacing %s linked to %s with real dir', br_link, br_path)
            sdk2.paths.make_folder(br_link, delete_content=True)
            packed_destination = br_link
        paths_to_pack = sorted([os.path.join(br_path, x) for x in os.listdir(br_path)])
        pack_and_remove(paths_to_pack, packed_destination)
