from sandbox import sdk2
from sandbox.common.types import resource as ctr


class AutocheckLogs(sdk2.Resource):
    """
        Build check logs.
    """
    auto_backup = False
    calc_md5 = False
    restart_policy = ctr.RestartPolicy.IGNORE


class YaMakeMetaGraphResult(sdk2.Resource):
    """ Resource for store meta graph """

    # common attributes
    releasable = False
    any_arch = True
    ttl = 2
    sync_upload_to_mds = False
    restart_policy = ctr.RestartPolicy.IGNORE
    share = False

    # Custom attributes
    left_revision = sdk2.parameters.Integer("left_revision", default=None)
    left_url = sdk2.parameters.String('left_url', default="")
    left_patch = sdk2.parameters.String('left_patch', default="")

    right_revision = sdk2.parameters.Integer("right_revision", default=None)
    right_url = sdk2.parameters.String('right_url', default="")
    right_patch = sdk2.parameters.String('right_patch', default="")

    circuit_type = sdk2.parameters.String('circuit_type', default='unknown')
    is_dummy_arcadia = sdk2.parameters.Bool('is_dummy_arcadia', default=False)
    targets = sdk2.parameters.String('targets', default='autocheck')
    autocheck_config_path = sdk2.parameters.String("autocheck_config_path", default="")

    partition_index = sdk2.parameters.Integer("partition_index", default=0)
    partitions_count = sdk2.parameters.Integer("partitions_count", default=1)

    kind = sdk2.parameters.String("Resource kind (acceptance, stable, prestable, ...)", default='unknown')
    source = sdk2.parameters.String("Resource source (AutocheckBuildParent2, ChangesDetector, ...)", default="unknown")

    correct_order = sdk2.parameters.Bool("Is right a new graph and left is old", default=False)
