from sandbox import sdk2

import sandbox.common.types.task as ctt
import sandbox.common.types.resource as ctr

from sandbox.projects.autocheck.lib.core import betatesters


TASKS_RESOURCE_OWNER = 'AUTOCHECK_ACCEPTANCE'
LIMIT_SEARCH = 100


def get_query(task):
    attrs = {'autocheck_tasks': True, 'released': task.Parameters.binary_executor_release_type}
    if task.Parameters.binary_executor_release_type == ctt.ReleaseStatus.STABLE and betatest_task(task):
        attrs['released'] = ctt.ReleaseStatus.PRESTABLE
    return {
        'attrs': attrs,
        'owner': TASKS_RESOURCE_OWNER,
        'state': [ctr.State.READY],
    }


def betatest_task(task):
    if not task.Parameters.commit_author:
        return False

    beta_testers = betatesters.get_betatesters(task)

    if task.Parameters.commit_author not in beta_testers:
        return False

    prestable_resource = sdk2.service_resources.SandboxTasksBinary.find(
        attrs={'autocheck_tasks': True, 'released': ctt.ReleaseStatus.PRESTABLE},
        owner=TASKS_RESOURCE_OWNER,
        state=ctr.State.READY
    ).limit(LIMIT_SEARCH).first()
    if not prestable_resource:
        return False

    stable_resource = sdk2.service_resources.SandboxTasksBinary.find(
        attrs={'autocheck_tasks': True, 'released': ctt.ReleaseStatus.STABLE},
        owner=TASKS_RESOURCE_OWNER,
        state=ctr.State.READY
    ).limit(LIMIT_SEARCH).first()
    if not stable_resource:
        return False

    if prestable_resource.commit_revision < stable_resource.commit_revision:
        return False

    return True
