import aniso8601
import calendar
import collections
import datetime
import json
import logging
import time
import urllib2

import sandbox.common.types.task as ctt
from sandbox.common import utils


def set_range_to_stages(task, name, start_time, finish_time):
    task.Context.__STAGES[name + '_started'] = start_time
    task.Context.__STAGES[name + '_finished'] = finish_time


# XXX: need only for old charts, remove it when old charts will not be needed
def process_results(task, partition_times, sub_status):
    def fetch_task_times(task_id):
        for _ in range(3):
            try:
                url = 'https://sandbox.yandex-team.ru/api/v1.0/task/{task}/audit'.format(task=task_id)
                return json.loads(urllib2.urlopen(url, timeout=10).read())
            except Exception:
                time.sleep(5)
        logging.warning('Unable to fetch times for task %d', task_id)
        return None

    def make_timestamp(dt):
        utc_dt = aniso8601.parse_datetime(dt)
        timestamp = calendar.timegm(utc_dt.timetuple())
        local_dt = datetime.datetime.fromtimestamp(timestamp)
        return time.mktime(local_dt.replace(microsecond=utc_dt.microsecond).timetuple())

    def refactor_times(times_list):
        result = collections.defaultdict(list)
        for item in sorted(times_list, key=lambda x: x['time']):
            sts = item.get('status')
            sts = sts.lower() if sts else ''
            result[sts] = sorted(result[sts] + [make_timestamp(item['time'])])
        return result

    task.Context.time_metrics = sub_status.time_metrics
    task.Context.__STAGES = sub_status.stages
    task.Context.cmake_work_time = sub_status.cmake_work_time
    task.Context.make_work_time = sub_status.make_work_time
    task.Context.tests_work_time = sub_status.tests_work_time

    if not task.Context.time_metrics:
        return

    set_range_to_stages(task, 'failed-subtasks-lag', partition_times['start'][0], partition_times['start'][-1])

    self_times = refactor_times(fetch_task_times(task.id))
    logging.debug('Times for task %d are %s', task.id, json.dumps(self_times, indent=4, sort_keys=True))

    set_range_to_stages(task, 'first-parent-queue-lag', self_times['draft'][0], self_times['preparing'][0])
    set_range_to_stages(task, 'first-parent-preparing', self_times['preparing'][0], self_times['executing'][0])
    set_range_to_stages(task, 'first-parent-executing', self_times['executing'][0], partition_times['start'][0])

    set_range_to_stages(task, 'build-task-finishing', partition_times['finish'][-1], partition_times['finish'][-1])
    set_range_to_stages(task, 'wait-child', partition_times['finish'][-1], partition_times['finish'][-1])

    set_range_to_stages(task, 'last-parent-queue-lag', partition_times['finish'][-1], partition_times['finish'][-1])
    set_range_to_stages(task, 'last-parent-preparing', partition_times['finish'][-1], partition_times['finish'][-1])

    base_time = task.Context.time_metrics['commit_time']
    for status in utils.chain(ctt.Status.Group.QUEUE, ctt.Status.PREPARING, ctt.Status.EXECUTING, ctt.Status.WAIT_TASK):
        status = status.lower()
        if status in self_times:
            task.Context.time_metrics['first_fallback_' + status] = self_times[status][0] - base_time
            if len(self_times[status]) > 1:
                task.Context.time_metrics['last_fallback_' + status] = self_times[status][-1] - base_time
