# TODO: Use ggaas/pool_constructor instead
#       Don't forget to change it


class Defaults(object):
    POOL_TREE_MAP = {
        'distbuild-vla': '//vla/',
        'distbuild-sas-00': '//sas/',
        'distbuild-man': '//man/',
        'distbuild-sas-01': '//sas_gg/',
    }
    POOL_TREE_MAP_TESTING = {
        'distbuild-vla': '//test_vla/',
        'distbuild-sas': '//test_sas/',
        'distbuild-man': '//test_man/',
    }
    GG_TREE_NAME = "//sas_gg/"
    GG_FORCED_POOL_NAME = 'autocheck/gg/precommits/public'
    GG_POSTCOMMIT_TREE_NAME = "//sas/"
    GG_POSTCOMMIT_FORCED_POOL_NAME = 'autocheck/gg/postcommits/public'
    GG_PRECOMMIT_COORDINATORS_FILTER = 'distbuild-sas-01'
    GG_POSTCOMMIT_COORDINATORS_FILTER = 'distbuild-sas-00'
    DEFAULT_PRECOMMIT_POOL_NAME = 'autocheck/precommits/public'
    DEFAULT_POSTCOMMIT_POOL_NAME = 'autocheck/postcommits/public'


def construct_pool_name(coordinators_filter, pool_tree, pool_name, is_precommit, is_testing=False):
    tree_name = _get_tree_name(pool_tree, coordinators_filter, is_testing)
    if tree_name:
        if is_precommit:
            default_pool_suffix = Defaults.DEFAULT_PRECOMMIT_POOL_NAME
        else:
            default_pool_suffix = Defaults.DEFAULT_POSTCOMMIT_POOL_NAME
        pool_name = (pool_name or default_pool_suffix).lstrip('/')
        return tree_name + pool_name
    return None


def construct_gg_pool_name(coordinators_filter, pool_tree, pool_name, is_precommit):
    tree_name = _get_gg_tree_name(pool_tree, coordinators_filter, is_precommit)
    if tree_name:
        if tree_name == Defaults.GG_TREE_NAME:
            default_pool_suffix = Defaults.GG_FORCED_POOL_NAME
        elif tree_name == Defaults.GG_POSTCOMMIT_TREE_NAME:
            default_pool_suffix = Defaults.GG_POSTCOMMIT_FORCED_POOL_NAME
        elif is_precommit:
            default_pool_suffix = Defaults.GG_FORCED_POOL_NAME
        else:
            default_pool_suffix = Defaults.GG_POSTCOMMIT_FORCED_POOL_NAME
        pool_name = (pool_name or default_pool_suffix).lstrip('/')
        return tree_name + pool_name
    return None


def _get_gg_tree_name(pool_tree, coordinators_filter, is_precommit):
    if pool_tree and not pool_tree.endswith('/'):
        pool_tree += '/'

    pool_tree = pool_tree or Defaults.POOL_TREE_MAP.get(coordinators_filter)
    if not pool_tree:
        if is_precommit:
            pool_tree = Defaults.GG_TREE_NAME
        else:
            pool_tree = Defaults.GG_POSTCOMMIT_TREE_NAME
    return pool_tree


def _get_tree_name(pool_tree, coordinators_filter, is_testing):
    if pool_tree and not pool_tree.endswith('/'):
        pool_tree += '/'

    if is_testing:
        pool_tree_map = Defaults.POOL_TREE_MAP_TESTING
    else:
        pool_tree_map = Defaults.POOL_TREE_MAP

    if coordinators_filter:
        coordinators_filter = coordinators_filter.lower()

    return pool_tree or pool_tree_map.get(coordinators_filter)
