import logging


def tag_name(name):
    return 'AC_ERROR_' + name if name else name


def analyze_context(ctx):
    if 'task_error_message' in ctx:
        task_error_message = ctx['task_error_message']
        if 'AutocheckBuildError' in task_error_message:
            if 'failed to obtain' in task_error_message:
                return 'DISTBS_FAILED_DOWNLOAD'
            if 'Build return code is -9' in task_error_message:
                return 'SB_YA_KILLED'
            if 'Cannot allocate memory' in task_error_message:
                return 'SB_MEMORY_ALLOCATION_PROBLEM'
        if 'RemoteCommandError' in task_error_message:
            if 'Process exceeds time limit' in task_error_message:
                return 'DISTBS_PROCESS_OUT_OF_TIME_LIMIT'
            elif 'SERVICE UNAVAILABLE' in task_error_message:
                return 'SP_UNAVAILABLE'
            else:
                return 'DISTBS_REMOTE_COMMAND_ERROR'
        if 'NotRetriableDistbsException' in task_error_message:
            if 'Displaced by' in task_error_message:
                return 'BUILD_DISPLACED'
        if 'StreamingException' in task_error_message:
            if 'error is timeout' in task_error_message:
                return 'SP_TIMEOUT'
        if '410 Client Error: GONE' in task_error_message:
            return 'SB_FILE_GONE'
    return None


def analyze_audit(audit):
    logging.debug("analyze_audit: audit = %s", audit)
    if audit and 'message' in audit[-1]:
        message = audit[-1]['message']
        if 'Switched to FAILURE instead of TIMEOUT.' in message:
            return 'UN_TIMEOUT'
        if 'Clear tasks on dead host' in message:
            return 'SB_DEAD_HOST'
        if 'rejected task: Client is shutting down.' in message:
            return 'SB_REJECT_TASK'

    return None


def analyze_task(ctx, read_audit):
    result = analyze_context(ctx) or analyze_audit(read_audit()) or 'UNKNOWN_PROBLEM'
    if result == 'UN_TIMEOUT' and ctx.get('is_pessimized'):
        result = 'UN_PESSIMIZED_TASK_TIMEOUT'
    return tag_name(result)
