import logging
import time
import traceback

from sandbox.common import config


def unified_agent_wrapper():
    import logbroker.unified_agent.client.python as un_agent
    client = un_agent.Client(config.Registry().common.unified_agent.autocheck.uri)
    session = client.create_session()
    return UnifiedAgentWrapper(session)


class UnifiedAgentWrapper(object):
    def __init__(self, session):
        logging.debug('Create unified agent client and session')
        self.session = session

    def send(self, payload, meta=None):
        logging.debug('Send to unified agent payload: %s', payload)
        try:
            self.session.send(payload, time.time(), meta)
        except Exception:
            logging.debug('Fail sending payload through unified agent:\n%s', traceback.format_exc())

    def close(self):
        logging.debug('Close unified agent session')
        self.session.close()
