# -*- encoding: utf-8 -*-
from __future__ import unicode_literals

import logging

from sandbox import sdk2
from sandbox.projects.common import binary_task

from sandbox.projects.avia.base import AviaBaseTask

log = logging.getLogger(__name__)


class AviaStatisticsUpdateRecentDirectionPopularity(binary_task.LastBinaryTaskRelease, AviaBaseTask):
    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        disk_space = 128  # 128 Megs or less
        ram = 1024  # 128 Megs or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):

        # binary task release parameters
        ext_params = binary_task.binary_release_parameters(stable=True)

        with sdk2.parameters.Group('Yt parameters') as yt_group:
            yt_proxy = sdk2.parameters.String('Proxy', default='hahn', required=True)
            yt_token = sdk2.parameters.YavSecret('YT token', default='sec-01dfxmszhq27tk66hm107d0ycd', required=True)

        with sdk2.parameters.Group('YDB parameters') as ydb_group:
            ydb_cluster = sdk2.parameters.String('Cluster', default='ydb-ru-prestable.yandex.net:2135', required=True)
            ydb_database = sdk2.parameters.String(
                'Database',
                default='/ru-prestable/ticket/testing/avia_statistics',
                required=True,
            )
            ydb_token = sdk2.parameters.YavSecret('YDB token', default='sec-01e149a59chjhzr2c1f6wcqdef', required=True)
            table_name = sdk2.parameters.String('Table name', default='recent_direction_popularity', required=True)

        days = sdk2.parameters.Integer('Days', default=30, required=True)

    def on_execute(self):
        import os
        import sys
        from travel.avia.avia_statistics.updaters.recent_direction_popularity.lib.runner import run_func

        logging.basicConfig(level=logging.INFO, stream=sys.stdout)
        env_mapping = [
            ('YT_PROXY', self.Parameters.yt_proxy),
            ('YT_TOKEN', self.Parameters.yt_token.data()['token']),
            ('YDB_TOKEN', self.Parameters.ydb_token.data()['token']),
            ('YDB_DATABASE', self.Parameters.ydb_database),
            ('YDB_CLUSTER', self.Parameters.ydb_cluster),
        ]
        for key, value in env_mapping:
            os.environ[key] = value

        run_func(table_name=self.Parameters.table_name, days=self.Parameters.days)
