# -*- encoding: utf-8 -*-
from __future__ import unicode_literals

import logging

from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.avia.base import AviaBaseTask

log = logging.getLogger(__name__)


class AviaStatisticsUpdateRoutes(binary_task.LastBinaryTaskRelease, AviaBaseTask):
    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        disk_space = 128  # 128 Megs or less
        ram = 128  # 128 Megs or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):

        # binary task release parameters
        ext_params = binary_task.binary_release_parameters(stable=True)

        with sdk2.parameters.Group('Yt parameters'):
            yt_proxy = sdk2.parameters.String('Proxy', default='hahn', required=True)
            yt_token = sdk2.parameters.YavSecret('YT token', default='sec-01dfxmszhq27tk66hm107d0ycd', required=True)

        with sdk2.parameters.Group('YDB parameters'):
            ydb_cluster = sdk2.parameters.String('Cluster', default='ydb-ru-prestable.yandex.net:2135', required=True)
            ydb_database = sdk2.parameters.String('Database', default='/ru-prestable/ticket/testing/avia_statistics', required=True)
            ydb_table = sdk2.parameters.String('Table', default='routes', required=True)
            ydb_token = sdk2.parameters.YavSecret('YDB token', default='sec-01e149a59chjhzr2c1f6wcqdef', required=True)

        batch_size = sdk2.parameters.Integer(
            'Batch size',
            required=True,
            default=1000,
        )
        landing_routes_table = sdk2.parameters.String('YT table with landing routes', default='//home/avia/avia-statistics/landing-routes', required=True)

    def on_execute(self):
        super(AviaStatisticsUpdateRoutes, self).on_execute()
        import ydb

        from travel.avia.library.python.lib_yt.client import configured_client
        from travel.avia.library.python.ydb.session_manager import YdbSessionManager
        from travel.avia.avia_statistics.routes_updater.lib.updater import RoutesUpdater
        from travel.avia.avia_statistics.routes_updater.lib.table import RoutesTable
        from travel.avia.avia_statistics.landing_routes import get_landing_routes

        yt_client = configured_client(self.Parameters.yt_proxy, self.Parameters.yt_token.data()['token'])

        ydb_config = ydb.DriverConfig(
            endpoint=self.Parameters.ydb_cluster,
            database=self.Parameters.ydb_database,
            auth_token=self.Parameters.ydb_token.data()['token']
        )

        session_manager = YdbSessionManager(ydb_config)
        routes_table = RoutesTable(
            session_manager,
            self.Parameters.ydb_database,
            self.Parameters.ydb_table,
        )
        landing_routes = get_landing_routes(yt_client, self.Parameters.landing_routes_table)
        routes_updater = RoutesUpdater(
            landing_routes,
            routes_table,
            self.Parameters.batch_size,
        )
        routes_updater.update()
