# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from sandbox import sdk2
from sandbox.sdk2 import yav

from sandbox.projects.Travel.tasks.tools.solomon_mixin import CommonTaskTrackerMixin

SOLOMON_CLUSTER_BY_ENV = {
    'TESTING': 'sandbox_testing',
    'PRODUCTION': 'sandbox_production',
}


class AviaBaseTask(CommonTaskTrackerMixin, sdk2.Task):
    """
    Базовый класс нужен, чтобы вынести общую для всех сендбокс задач логику,
    например, отправки статуса выполнения задачи в соломон.
    """
    SOLOMON_SECRET_ID = 'sec-01dwy9p37p1e8j94c5kp9zqmw1'
    SOLOMON_SECRET_KEY = 'oauth'
    SOLOMON_SECRET_VERSION = ''
    _resolved_solomon_token = None

    @property
    def solomon_token(self):
        if not self._resolved_solomon_token:
            secret_data = yav.Secret(self.SOLOMON_SECRET_ID, self.SOLOMON_SECRET_VERSION).data()
            self._resolved_solomon_token = secret_data[self.SOLOMON_SECRET_KEY]
        return self._resolved_solomon_token

    def fill_task_tracker_config(self):
        """
        Для алертов об упавших задачах определяем настройки отправки метрик работы таска в соломон
        """
        self.task_tracker_config.enable_solomon = True
        self.task_tracker_config.solomon_track_start = True

        self.task_tracker_config.solomon_secret_token = self.SOLOMON_SECRET_ID
        self.task_tracker_config.solomon_secret_key = self.SOLOMON_SECRET_KEY
        self.task_tracker_config.solomon_secret_version = self.SOLOMON_SECRET_VERSION

        self.task_tracker_config.solomon_project = 'avia'
        self.task_tracker_config.solomon_cluster = 'sandbox_dev'
        self.task_tracker_config.solomon_service = 'sandbox'

        task_name = self.type.__name__
        self.task_tracker_config.source = '.'.join([self._solomon_prefix, task_name])
        self.task_tracker_config.host = task_name

        for env, solomon_cluster in SOLOMON_CLUSTER_BY_ENV.items():
            if env in self.Parameters.tags:
                self.task_tracker_config.solomon_cluster = solomon_cluster
                break

    @staticmethod
    def get_secret_value(secret, default_key):
        key = secret.default_key if secret.default_key is not None else default_key
        return secret.data()[key]
