# coding=utf-8
from __future__ import unicode_literals

import logging

import sandbox.sdk2.parameters as sb_parameters
from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.avia.base import AviaBaseTask

log = logging.getLogger(__name__)


class AviaSandboxBinaryTaskTemplate(binary_task.LastBinaryTaskRelease, AviaBaseTask):
    class Requirements(sdk2.Requirements):
        # configure this for your task, the more accurate - the better
        cores = 1  # exactly 1 core
        disk_space = 128  # 128 Megs or less
        ram = 128  # 128 Megs or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):

        a = 1
        b = 2

        some_vault = sb_parameters.Vault("sandbox vault entry")
        some_yav = sb_parameters.YavSecret("YAV secret identifier (with optional version)")

        with sb_parameters.Output():
            c = sb_parameters.Integer("Some sort of label")

        # binary task release parameters
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        super(AviaSandboxBinaryTaskTemplate, self).on_execute()
        self.Parameters.c = self.Parameters.a + self.Parameters.b
