# -*- coding: utf-8 -*-
# Django settings for rasp project.

import os

from avia_data.settings import *  # noqa
from common.settings import *  # noqa


ENVIRONMENT = 'dev'


DEBUG = False
DEBUG_PROPAGATE_EXCEPTIONS = False
TEMPLATE_DEBUG = False

HOST_URL = 'https://admin.avia.yandex-team.ru'

MYSQL_CONNECT_TIMEOUT = MYSQL_READ_TIMEOUT = MYSQL_WRITE_TIMEOUT = 3600 * 5  # для особо долгих скриптов


TIME_ZONE = 'Europe/Moscow'

USE_I18N = True
# Для нормальной работы админки
USE_L10N = True


# Make this unique, and don't share it with anybody.
SECRET_KEY = '6sm82tff48ajyfl6l+zwv4hbjp%8@iyynp*g6kn^mvb5ikdf5e'

TEMPLATE_CONTEXT_PROCESSORS = (
    'django.contrib.auth.context_processors.auth',
    'django.core.context_processors.debug',
    'django.core.context_processors.media',
    'django.core.context_processors.request',
    'django.core.context_processors.static',
    'django.contrib.messages.context_processors.messages',
    'www.context.default',
)

JINJA_EXTS = ['jinja2.ext.i18n']

JINJA_CONTEXT_PROCESSORS = (
    'django.core.context_processors.debug',
    'django.core.context_processors.media',
    'django.core.context_processors.request',
    'www.context.default',
)

JINJA_LIBRARIES = (
    'www.templatetags.block_found_routes',
    'www.templatetags.block_thread',
    'www.templatetags.common',
    'www.templatetags.durations',
    'www.templatetags.html',
    'www.templatetags.timezones',
    'currency.templatefilters',
)

JINJA_GLOBALS = (
    '__builtin__.min',
    '__builtin__.reversed',
    'datetime.timedelta',
    'django_russian.utils.qadjective',
    'django_russian.utils.qnoun',
    'django_russian.utils.qverb',
    'itertools.chain',
    'lib.translation.gettext',
    'math.floor',
    'math.ceil',
    'pytils.numeral.get_plural',
    'random.randint',
    'www.templatetags.block_tablo.geo_data',
    'www.templatetags.block_tablo.weather_city',
    'www.templatetags.block_tablo.weather_data',
    'www.templatetags.block_thread.wrong_date_disclaimer',
    'www.templatetags.common.media_url',
    'www.templatetags.tablo_sett_navigation.tablo_sett_nav_objects',
)

JINJA_FILTERS = (
    'django.template.defaultfilters.capfirst',
    'django.template.defaultfilters.date',
    'django.template.defaultfilters.urlencode',
    'django_russian.templatetags.russian.human_date',
    'django_russian.templatetags.russian.human_duration',
    'django_russian.templatetags.russian.quantity',
    'pytils.templatetags.pytils_dt.ru_strftime',
    'www.templatetags.block_tablo.one_station_title',
    'www.templatetags.block_tablo.translate_wind_direction',
    'www.templatetags.block_thread.bold_duration',
    'www.templatetags.filters.ins_nbsp',
)


MIDDLEWARE_CLASSES = ()


INSTALLED_APPS = ()


SECRET_SALT = 'b1818c0846d2bb22b30e17b6dbd678be'

LOG_LEVEL_NAME = 'INFO'


PROJECT_CODE = 'admin'

AVIA_NATIONAL_VERSIONS = ('ru', 'ua', 'tr', 'com', 'kz')

DATABASES = {
    'default': {
        'ENGINE': 'common.utils.mysql_switcher',
        'USER': os.getenv('AVIA_DB_USER'),
        'PASSWORD': os.getenv('AVIA_DB_PASSWORD'),
        'NAME': 'avia',
        'STORAGE_ENGINE': "InnoDB",
    },
}


LOG_PATH = os.getenv('LOG_PATH')
CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.locmem.LocMemCache',
        'timeout': 60,
        'LONG_TIMEOUT': 60,
    }
}


if os.getenv('AVIA_DB_GROUP'):
    from common.utils.dcutils import Conductor
    conductor = Conductor(
        log_file_path=os.path.join(LOG_PATH, 'dcutils.log'),
        cache_path=LOG_PATH,
    )
    mysql_group = os.getenv('AVIA_DB_GROUP')
    replicas = conductor.get_mysql_replicainfo(mysql_group)
    DATABASES['default']['REPLICAS'] = replicas.replicas
    DATABASES['default']['HOST'] = None
    CACHES.update({
        'replica_set': {
            'BACKEND': 'django.core.cache.backends.locmem.LocMemCache',
            'timeout': 60,
        }
    })

else:
    DATABASES['default']['HOST'] = os.getenv('AVIA_DB_HOST')


MEDIA_ROOT = os.getenv('AVIA_MEDIA_ROOT')
MDS_S3_ENDPOINT_URL = os.getenv('MDS_S3_ENDPOINT_URL')
MDS_S3_AVIA_ADMIN_BUCKET = os.getenv('MDS_S3_AVIA_ADMIN_BUCKET')
S3_CONFIGS = {
    'sitemaps':
        [
            ('avia-media/avia', os.path.join(MEDIA_ROOT, 'avia', 'sitemaps'), []),
            ('avia-media/avia', os.path.join(MEDIA_ROOT, 'avia', 'sitemap_com.tr.xml.gz'), []),
            ('avia-media/avia', os.path.join(MEDIA_ROOT, 'avia', 'sitemap_com.xml.gz'), []),
            ('avia-media/avia', os.path.join(MEDIA_ROOT, 'avia', 'sitemap_kz.xml.gz'), []),
            ('avia-media/avia', os.path.join(MEDIA_ROOT, 'avia', 'sitemap_ru.xml.gz'), []),
            ('avia-media/avia', os.path.join(MEDIA_ROOT, 'avia', 'sitemap_ua.xml.gz'), []),
        ],
}

ALLOW_GEOBASE = True
