# -*- coding: utf-8 -*-

from datetime import timedelta

from sandbox.projects.avia.lib.marker import JSONRPCMarkerReader, MarkerWriter, MarkerTransfer
from sandbox.projects.avia.import_marker import AviaImportMarker


class AviaImportBookandtripMarker(AviaImportMarker):
    """ Import marker from Bookandtrip """

    class Requirements(AviaImportMarker.Requirements):
        pass

    def on_execute(self):
        user_key = self._get_partner_secret('user_key')
        user_token = self._get_partner_secret('user_token')
        user_name = self._get_partner_secret('user_name')
        user_password = self._get_partner_secret('user_password')
        self._logger.info('Transferring date range: %s - %s', self._left_date, self._right_date)

        marker_transfer = MarkerTransfer(
            partner=self._partner,
            marker_writer=MarkerWriter(
                self.Parameters.source,
                self._logger,
                self.Parameters.yt_partner_booking_root,
                self._yt,
            ),
            marker_reader=JSONRPCMarkerReader(
                'https://api2.bookandtrip.ru/rpc/booking_list',
                user_key, user_token, user_name, user_password,
                self.geo_point_cache, self._logger
            ),
            logger=self._logger,
        )

        self._logger.info('Transferring date range: %s - %s', self._left_date, self._right_date)
        report_date = self._left_date
        while report_date <= self._right_date:
            marker_transfer.transfer(report_date)
            report_date += timedelta(days=1)

        self._logger.info('Stop: transferring data in date range')
