class CompanyCache(object):
    def __init__(self, yt, reference_yt_path):
        self._by_iata = {}
        self._yt = yt
        self._reference_yt_path = reference_yt_path
        self._precached = False

    def precache(self):
        for company in self._yt.read_table(self._reference_yt_path + '/company'):
            if company['iata']:
                self._by_iata[company['iata'].lower()] = company
        self._precached = True

        return self

    def company_id_by_iata(self, iata, silent=False):
        try:
            if not self._precached:
                self.precache()
            return self._by_iata[iata.lower()]['id']
        except KeyError:
            if silent:
                return None
            raise KeyError(
                'Company for IATA-code {!r} was not found'.format(iata)
            )
