# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from datetime import datetime

import pytz

MOSCOW_TIMEZONE = pytz.timezone('Europe/Moscow')

_EPOCH_UTC = datetime(1970, 1, 1, tzinfo=pytz.UTC)


def get_utc_now():
    return pytz.UTC.localize(datetime.utcnow())


def _dt_to_unixtime_utc(dt):
    return int((dt - _EPOCH_UTC).total_seconds())


def _round_unixtime(unixtime, base):
    return unixtime - unixtime % base


def _unixtime_to_dt(unixtime):
    return pytz.UTC.localize(datetime.utcfromtimestamp(unixtime))


def _unixtime_to_msk_dt(unixtime):
    return pytz.UTC.localize(datetime.utcfromtimestamp(unixtime)).astimezone(MOSCOW_TIMEZONE)


def _dt_to_string(timestamp):
    return timestamp.strftime('%Y-%m-%dT%H:%M:%S')


def _dt_to_date_string(timestamp):
    return timestamp.strftime('%Y-%m-%d')


def _timestamp_to_utc_string(timestamp):
    return _unixtime_to_dt(timestamp).strftime('%Y-%m-%dT%H:%M:%SZ')
