# coding=utf-8
class DestinationCache(object):
    """Кэшируем названия пунктов назначения по идентификатору.

    Идея в том, чтобы держать в одном месте и станции и населённые пункты.
    """
    def __init__(self, yt, reference_yt_path):
        self._title_by_id = {}
        self._yt = yt
        self._reference_yt_path = reference_yt_path
        self._precached = False

    def precache(self):
        for settlement in self._yt.read_table(self._reference_yt_path + '/settlement'):
            if settlement['id']:
                self._title_by_id[settlement['id']] = settlement['title']
        for station in self._yt.read_table(self._reference_yt_path + '/station'):
            if station['id']:
                self._title_by_id[station['id']] = station['title']
        self._precached = True

    @property
    def title_by_id(self):
        if not self._precached:
            self.precache()
        return self._title_by_id
