# -*- coding: utf-8 -*-
class GeoPointCache(object):
    def __init__(self, yt, reference_yt_path):
        self.station_cache = StationCache(yt, reference_yt_path)
        self.settlement_cache = SettlementCache(yt, reference_yt_path)

    def settlement_id_by_code(self, code):
        try:
            return self.station_cache.settlement_id_by_code(code)
        except KeyError:
            return self.settlement_cache.settlement_id_by_code(code)


class StationCache(object):
    def __init__(self, yt, reference_yt_path):
        self._by_code = {}
        self._yt = yt
        self._reference_yt_path = reference_yt_path
        self._precached = False

    def precache(self):
        for station in self._yt.read_table(self._reference_yt_path + '/station'):
            if station['iata']:
                self._by_code[station['iata'].lower()] = station
            if station['sirena']:
                self._by_code[station['sirena'].lower()] = station
        self._precached = True

        return self

    def settlement_id_by_code(self, code):
        try:
            if not self._precached:
                self.precache()
            return self._by_code[code.lower()]['city_id']
        except KeyError:
            raise KeyError(
                'Station for code {!r} was not found'.format(code)
            )


class SettlementCache(object):
    def __init__(self, yt, reference_yt_path):
        self._by_code = {}
        self._yt = yt
        self._reference_yt_path = reference_yt_path
        self._precached = False

    def precache(self):
        for settlement in self._yt.read_table(self._reference_yt_path + '/settlement'):
            if settlement['iata']:
                self._by_code[settlement['iata'].lower()] = settlement
            if settlement['sirena']:
                self._by_code[settlement['sirena'].lower()] = settlement
        self._precached = True

        return self

    def settlement_id_by_code(self, code):
        try:
            if not self._precached:
                self.precache()
            return self._by_code[code.lower()]['id']
        except KeyError:
            raise KeyError(
                'Settlement for code {!r} was not found'.format(code)
            )
