class PartnerCache(object):
    def __init__(self, yt, reference_yt_path):
        self._by_code = {}
        self._yt = yt
        self._reference_yt_path = reference_yt_path
        self._precached = False

    def precache(self):
        for partner in self._yt.read_table(self._reference_yt_path + '/partner'):
            if partner['code']:
                self._by_code[partner['code'].lower()] = partner

        self._precached = True

    def partner_by_code(self, partner_code):
        try:
            if not self._precached:
                self.precache()
            return self._by_code[partner_code.lower()]
        except KeyError:
            raise Exception(
                'Partner for code {!r} was not found'.format(partner_code)
            )
