class PointToIATACache(object):
    def __init__(self, ytc):
        self._point_to_iata = self._build(ytc)

    def get(self, point_key):
        return self._point_to_iata.get(point_key)

    def _build(self, ytc):
        result = {
            r['id']: r['iata']
            for r in ytc.read_table('//home/rasp/reference/settlement')
            if r['iata']
        }

        stations = list(ytc.read_table('//home/rasp/reference/station'))
        result.update({
            r['city_id']: r['iata']
            for r in stations
            if r['city_id'] not in result
        })

        result.update({
            r['id']: r['iata']
            for r in stations
        })

        return result
