# coding: utf8
import json
import logging

from sandbox.projects.rasp.qloud.api import QloudPublicApi as RaspQloudPublicApi


class QloudPublicApi(RaspQloudPublicApi):
    def create_stand_domain(self, application_name, stand_name, balancer_type):
        logging.info(
            'Creating domain '
            '{stand}.{application}.testing.avia.yandex.net with balancer_type: {balancer}'.format(
                application=application_name,
                stand=stand_name,
                balancer=balancer_type,
            ),
        )
        self._process_text_query(
            'post',
            self.URL + 'domains/avia.{application}.{stand}/{stand}.{application}.testing.avia.yandex.net'.format(
                application=application_name,
                stand=stand_name
            ),
            headers={'Content-type': 'application/x-www-form-urlencoded'},
            data='httpOnly=true&type={}&type=L7'.format(balancer_type)
        )

    def setup_deploy_hook(self, environment_id, deploy_hook):
        policy = self.get_policy(environment_id)
        policy['deployHook'] = deploy_hook
        self.set_policy(environment_id, policy)

    def get_policy(self, qloud_environment_id):
        return self._process_json_query(
            'get',
            self.URL + 'environment/policies/{}'.format(qloud_environment_id),
        )

    def set_policy(self, qloud_environment_id, policy):
        self._process_text_query(
            'post',
            self.URL + 'environment/policies/{}'.format(qloud_environment_id),
            data=json.dumps(policy),
            headers={'Content-type': 'application/json'},
        )
