# coding=utf-8
def fromstring(data):
    """Функция fromstring, защищённая от XXE.

    Взято отсюда: https://wiki.yandex-team.ru/security/For/web-developers/xxe/
    Связанные задачи:
     - https://st.yandex-team.ru/RASPTICKETS-15429
     - https://st.yandex-team.ru/RASPTICKETS-15655
    """
    from lxml import etree

    class FakeDTDResolver(etree.Resolver):
        def resolve(self, url, id_, context):
            return self.resolve_string('', context)

    parser = etree.XMLParser(remove_blank_text=True, resolve_entities=False, no_network=True)
    parser.resolvers.add(FakeDTDResolver())
    return etree.fromstring(data, parser)
