import json

STAT_HOST = 'https://upload.stat.yandex-team.ru/_api/report/data'
STAT_BETA_HOST = 'https://upload.stat-beta.yandex-team.ru/_api/report/data'


def post_data_to_stat(name, data, token, scale='d', beta=False, _append_mode=1, raw_data=False):
    import requests
    """data is dict of values :
    data = [
        {'fielddate': '2015-02-03', 'project': 'Portal', 'name': '400', 'field1': 99},
        {'fielddate': '2015-02-03', 'project': 'Morda', 'name': '400', 'field1': 30},
        {'fielddate': '2015-02-04', 'project': 'Portal', 'name': '400', 'field1': 19},
        {'fielddate': '2015-02-04', 'project': 'Morda', 'name': '400', 'field1': 102},
    ]
    """
    data = '{{"values": {}}}'.format(data) if raw_data else json.dumps({'values': data})
    r = requests.post(
        STAT_HOST if not beta else STAT_BETA_HOST,
        headers={
            'Authorization': 'OAuth {}'.format(token),
        },
        data={
            'name': name,
            'scale': scale,
            'json_data': data,
            '_append_mode': _append_mode,
        },
        verify=False,
    )
    return r
