# -*- coding: utf-8 -*-

import sandbox.common.types.notification as ctn
import logging
import logging.handlers
import time
import re
import os

from sandbox import sdk2
from sandbox.projects.common import file_utils as fu
from sandbox.projects.tank.ShootViaTankapi import ShootViaTankapi
from sandbox.common.types import resource as ctr
from sandbox.common.types import task as ctt

from sandbox.projects.avia.base import AviaBaseTask

TANKS = [
    'tank-1.tank.load.frontend.avia.stable.qloud-d.yandex.net:8083'
]


def logger():
    loggerr = logging.getLogger('%s_%s' % (__name__, time.time()))
    loggerr.setLevel(logging.DEBUG)
    formatter = logging.Formatter('%(asctime)s %(levelname)s [%(processName)s: %(threadName)s] %(message)s')
    file_handler = logging.handlers.RotatingFileHandler(
        'oops_metashooting.log',
        maxBytes=1024 * 1024,
        backupCount=5
    )

    file_handler.setLevel(logging.DEBUG)
    file_handler.setFormatter(formatter)
    loggerr.addHandler(file_handler)
    return loggerr


class FSLoadTesting(AviaBaseTask):
    """ Task for shooting on Avia st/LOAD-679 """

    def start_shooting(self, desc, ammo_source, ammo_resource, config_content, timings):
        subtask_shoot = ShootViaTankapi(
            self,
            description=desc,
            ammo_source=ammo_source,
            ammo_resource=ammo_resource,
            config_source='file',
            config_content=config_content,
            tanks=TANKS,
            notifications=(
                sdk2.Notification(
                    [ctt.Status.FAILURE, ctt.Status.EXCEPTION, ctt.Status.NO_RES, ctt.Status.TIMEOUT],
                    ['avia-alerts'],
                    ctn.Transport.EMAIL
                ) if timings else ''
            )
        ).enqueue()
        logger().info('Subtask with shooting is started')
        raise sdk2.WaitTask([subtask_shoot.id], ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True,
                            timeout=14400)

    def on_execute(self):

        avia_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
        logging.info(avia_dir)
        tank_configs = os.listdir(os.path.join(avia_dir, 'AviaLoadTesting/configs'))
        logger().info('Avia shooting configs: %s', tank_configs)

        for conf_name in tank_configs:
            with self.memoize_stage["shooting_{0}".format(conf_name)]:
                timings = True if 'timings' in conf_name else False
                config_content = fu.read_file(os.path.join(avia_dir, 'AviaLoadTesting/configs/', conf_name))
                ammo_lable = re.split(r'_', conf_name)
                resource = sdk2.Resource.find(type='AMMO_FILE', state=ctr.State.READY, attrs={'ammo_label': 'avia.' + ammo_lable[0]}).first()
                self.start_shooting(conf_name, 'resource', resource, config_content, timings)
