import logging
from datetime import date, timedelta

import yaml

from sandbox import sdk2
from sandbox.common.types.task import Status
from sandbox.projects.tank.GenerateAmmoFromYT import GenerateAmmoFromYT
from sandbox.sandboxsdk.svn import Arcadia

from sandbox.projects.avia.base import AviaBaseTask


class AviaLoadGenerateAmmo(AviaBaseTask):
    class Parameters(sdk2.Parameters):

        yql_result_save = sdk2.parameters.Bool('Save YQL results to resources?', required=True)
        config_path = sdk2.parameters.SvnUrl('Path to config in arcadia', required=True)
        label_format = sdk2.parameters.String('Label format', default='avia.{}', required=True)
        yql_token_owner = sdk2.parameters.String('YQL token owner')
        yql_token_name = sdk2.parameters.String('YQL token name', default='YQL_TOKEN')

    def on_execute(self):
        default_date = str(date.today() - timedelta(days=2))
        logging.debug('Downloading configs from {}'.format(self.Parameters.config_path))
        config = yaml.load(Arcadia.cat(self.Parameters.config_path))
        logging.debug(config)
        subtasks = []
        with self.memoize_stage.generate_ammo:
            for app_name, app_config in config.items():
                try:
                    subtasks.append(
                        GenerateAmmoFromYT(
                            self,
                            owner=self.Parameters.owner,
                            priority=self.Parameters.priority,

                            yql_result_save=self.Parameters.yql_result_save,
                            yql_query=app_config['yql_query'].replace('{date}', default_date),
                            yql_token_owner=self.Parameters.yql_token_owner,
                            yql_token_name=self.Parameters.yql_token_name,

                            ignore_values='\n'.join(app_config.get('ignore_lines', [])),
                            headers=app_config.get('headers', {}),
                            ammo_label=self.Parameters.label_format.format(app_name),
                        ).enqueue()
                    )
                except Exception:
                    logging.exception('Error while handling {}'.format(app_name))
            logging.debug('Waiting for subtasks')
            raise sdk2.WaitTask(subtasks, Status.Group.FINISH + Status.Group.BREAK, wait_all=True)
