USE hahn;
PRAGMA yt.InferSchema = '1';

DECLARE $actual_flights_input_table AS String;

$format = DateTime::Format("%Y-%m-%d");

$current_date = CurrentTzDateTime("Europe/Moscow");
$current_week_start_date = $format($current_date - DateTime::IntervalFromDays(7));
$previous_week_start_date = $format($current_date - DateTime::IntervalFromDays(14));
$month_ago = $format($current_date - DateTime::IntervalFromDays(30));
$month_ago_week_start_date = $format($current_date - DateTime::IntervalFromDays(37));
$current_date = $format($current_date);


$distinct_routes = (
    SELECT DISTINCT
        routes.flight_number as flight_number,
        routes.airline_id as airline_id,
        from_country_id, from_city_id, to_country_id, to_city_id,
        CASE WHEN ($current_week_start_date <= routes.flight_date AND routes.flight_date < $current_date) THEN 'this-week'
             WHEN ($previous_week_start_date <= routes.flight_date AND routes.flight_date < $current_week_start_date) THEN 'last-week'
             WHEN ($month_ago_week_start_date <= routes.flight_date AND routes.flight_date < $month_ago) THEN 'last-month'
             ELSE ''
        END as week_group
        FROM $actual_flights_input_table as routes

        LEFT JOIN `//home/rasp/reference/settlement` as settlement_from_by_iata
        ON routes.departure_airport == settlement_from_by_iata.iata
        LEFT JOIN `//home/rasp/reference/settlement` as settlement_from_by_sirena
        ON routes.departure_airport == settlement_from_by_sirena.sirena
        LEFT JOIN `//home/rasp/reference/settlement` as settlement_to_by_iata
        ON routes.arrival_airport == settlement_to_by_iata.iata
        LEFT JOIN `//home/rasp/reference/settlement` as settlement_to_by_sirena
        ON routes.arrival_airport == settlement_to_by_sirena.sirena

        LEFT JOIN `//home/rasp/reference/station` as station_from_by_iata
        ON routes.departure_airport == station_from_by_iata.iata
        LEFT JOIN `//home/rasp/reference/station` as station_from_by_sirena
        ON routes.departure_airport == station_from_by_sirena.sirena
        LEFT JOIN `//home/rasp/reference/station` as station_to_by_iata
        ON routes.arrival_airport == station_to_by_iata.iata
        LEFT JOIN `//home/rasp/reference/station` as station_to_by_sirena
        ON routes.arrival_airport == station_to_by_sirena.sirena
);

SELECT
    from_city_id,
    COUNT_IF(week_group == 'this-week' AND from_country_id == 'l225' AND to_country_id == 'l225') as this_week_local_flights,
    COUNT_IF(week_group == 'last-week' AND from_country_id == 'l225' AND to_country_id == 'l225') as last_week_local_flights,
    COUNT_IF(week_group == 'last-month' AND from_country_id == 'l225' AND to_country_id == 'l225') as last_month_local_flights,
    COUNT_IF(week_group == 'this-week' AND ((from_country_id == 'l225' AND to_country_id != 'l225') OR (from_country_id != 'l225' AND to_country_id == 'l225'))) as this_week_foreign_flights,
    COUNT_IF(week_group == 'last-week' AND ((from_country_id == 'l225' AND to_country_id != 'l225') OR (from_country_id != 'l225' AND to_country_id == 'l225'))) as last_week_foreign_flights,
    COUNT_IF(week_group == 'last-month' AND ((from_country_id == 'l225' AND to_country_id != 'l225') OR (from_country_id != 'l225' AND to_country_id == 'l225'))) as last_month_foreign_flights,
FROM $distinct_routes
GROUP BY from_city_id;
