USE hahn;

DECLARE $actual_flights_output_table AS String;

$format = DateTime::Format("%Y-%m-%d");

$current_date = CurrentTzDateTime("Europe/Moscow");
$current_week_start_date = $format($current_date - DateTime::IntervalFromDays(7));
$previous_week_start_date = $format($current_date - DateTime::IntervalFromDays(14));
$month_ago = $format($current_date - DateTime::IntervalFromDays(30));
$month_ago_week_start_date = $format($current_date - DateTime::IntervalFromDays(37));
$current_date = $format($current_date);

$departure = (
SELECT DISTINCT flight_number, airline_id, String::ToUpper(airport) as airport, flight_date, direction, status
FROM RANGE(`//logs/avia-update-flight-status-log/1d`, $month_ago_week_start_date, $current_date)
WHERE direction = 'departure' AND status = 'departed' AND flight_date != ''
 AND ($previous_week_start_date <= flight_date) OR ($month_ago_week_start_date <= flight_date AND flight_date < $month_ago)
);

$arrival = (
SELECT DISTINCT flight_number, airline_id, String::ToUpper(airport) as airport, flight_date, direction, status
FROM RANGE(`//logs/avia-update-flight-status-log/1d`, $month_ago_week_start_date, $current_date)
WHERE direction = 'arrival' AND status = 'arrived' AND flight_date != ''
);

INSERT INTO
    $actual_flights_output_table
WITH TRUNCATE
    SELECT
        aviacompany.iata as iata,
        departure.flight_number as flight_number,
        departure.airline_id as airline_id,
        departure.airport as departure_airport,
        arrival.airport as arrival_airport,
        departure.flight_date as flight_date
    FROM $departure as departure
    LEFT JOIN $arrival as arrival
    ON departure.flight_number = arrival.flight_number AND departure.airline_id = arrival.airline_id AND departure.flight_date = arrival.flight_date
    LEFT JOIN `//home/rasp/reference/aviacompany` as aviacompany
    ON departure.airline_id = aviacompany.id
;
