# coding=utf-8
from __future__ import unicode_literals

import logging
import os

from sandbox import sdk2
from sandbox.projects.avia.base import AviaBaseTask
from sandbox.projects.common import binary_task


class TravelAviaPriceIndexDumpToYt(binary_task.LastBinaryTaskRelease, AviaBaseTask):
    class Requirements(sdk2.Requirements):
        # configure this for your task, the more accurate - the better
        cores = 1  # exactly 1 core
        disk_space = 128  # 128 Megs or less
        ram = 128  # 128 Megs or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):

        with sdk2.parameters.Group('Query params and formatting'):
            with sdk2.parameters.RadioGroup('National version') as national_version:
                national_version.values.RU = national_version.Value('ru', default=True)

            days = sdk2.parameters.Integer('Min prices from N days in future', default=30, required=True)
            max_transfers = sdk2.parameters.Integer('Max transfers', default=999, required=True)
            search_url_template = sdk2.parameters.String(
                'Search URL template',
                description=(
                    'https://travel.yandex.ru/avia/search/result/?adult_seats=1&children_seats=0&'
                    'fromId=c{from_id}&infant_seats=0&klass=economy&toId=c{to_id}&when={when}'
                ),
                required=True,
            )
            route_url_template = sdk2.parameters.String(
                'Route url template',
                description='https://travel.yandex.ru/avia/routes/{from_slug}--{to_slug}/',
                required=True,
            )

        with sdk2.parameters.Group('YT'):
            with sdk2.parameters.Group('Yt parameters'):
                yt_proxy = sdk2.parameters.String('Proxy', default='hahn', required=True)
                yt_token = sdk2.parameters.YavSecret(
                    'YT token',
                    default='sec-01dfxmszhq27tk66hm107d0ycd',
                    required=True,
                )

            landing_routes_table = sdk2.parameters.String(
                'Landing routes table',
                description='//home/avia/avia-statistics/landing-routes',
                required=True,
            )

        with sdk2.parameters.Group('Price index ENV'):
            price_index_pgaas_cluster_id = sdk2.parameters.String(
                'Price index database cluster id',
                default='mdb9sssbmtcje8gtvlrc',
                required=True,
            )
            price_index_pgaas_database_name = sdk2.parameters.String(
                'Price index database name',
                default='price-index',
                required=True,
            )
            price_index_pgaas_user = sdk2.parameters.String(
                'Price index database user',
                default='avia',
                required=True,
            )
            price_index_pgaas_password = sdk2.parameters.YavSecret(
                'Price index database password',
                default='sec-01e84cae2rjpe3pvwjrt9c0phb',
                required=True,
            )
            price_index_pgaas_statement_timeout = sdk2.parameters.Integer(
                'Price index database statement timeout',
                description='seconds',
                default=300,
                required=True,
            )

            price_index_backend_host = sdk2.parameters.String(
                'Price index backend host',
                description='http://backend.production.avia.yandex.net',
                required=True,
            )

        output_table = sdk2.parameters.String(
            'Output table',
            description='//home/avia/testing/data/price-index/directions-ru-month',
            required=True,
        )

        # binary task release parameters
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        for k, v in {
            'PGAAS_CLUSTER_ID': self.Parameters.price_index_pgaas_cluster_id,
            'PGAAS_DATABASE_NAME': self.Parameters.price_index_pgaas_database_name,
            'PGAAS_USER_FOR_WORK': self.Parameters.price_index_pgaas_user,
            'PGAAS_PASSWORD_FOR_WORK': self.Parameters.price_index_pgaas_password.data()['password'],
            'PGAAS_STATEMENT_TIMEOUT': self.Parameters.price_index_pgaas_statement_timeout,

            'BACKEND_HOST': self.Parameters.price_index_backend_host,
        }.items():
            os.environ['AVIA_PRICE_INDEX_{}'.format(k)] = str(v)

        from travel.avia.price_index.bin.dump_to_yt.dumper import Dumper
        from travel.avia.library.python.lib_yt.client import configured_client

        dumper = Dumper(
            national_version=self.Parameters.national_version.lower(),
            search_url_template=self.Parameters.search_url_template,
            route_url_template=self.Parameters.route_url_template,
            yt_client=configured_client(self.Parameters.yt_proxy, self.Parameters.yt_token.data()['token']),
            landing_routes_table=self.Parameters.landing_routes_table,
            logger=logging.getLogger('Dumper'),
        )
        dumper.dump(
            days=self.Parameters.days,
            max_transfers=self.Parameters.max_transfers,
            yt_table=self.Parameters.output_table,
        )
