# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

log = logging.getLogger(__name__)

SQL_COPY_TEMPLATE = """\\copy {table_name}({columns}) from '{filename}' WITH DELIMITER E'\t' CSV"""


def update_pg_variant_price_stats(connection, yt_data_filename, table_name, columns):
    from pgspecial.main import PGSpecial

    pgspecial = PGSpecial()
    with connection.cursor() as cursor:
        cursor.execute('DELETE FROM {}'.format(table_name))
        pgspecial.execute(
            cur=cursor,
            sql=SQL_COPY_TEMPLATE.format(table_name=table_name, columns=','.join(columns), filename=yt_data_filename)
        )
        cursor.execute('SELECT COUNT(*) FROM {}'.format(table_name))
        row = cursor.fetchone()
        log.info('%s has %s rows', table_name, row[0])
