from sandbox import sdk2
from sandbox.common.types import resource as ctr


class AviaSharedFlightsLastUpdatedAmadeusResource(sdk2.Resource):
    """ Last Amadeus file processed by the shared flights parser """
    releasers = ["avia"]
    releasable = False
    share = False  # Do not share (create rbtorrent) resource
    auto_backup = True
    # common attributes
    restart_policy = ctr.RestartPolicy.IGNORE  # don't change the state
    # custom attributes
    last_parsed_date = sdk2.Attributes.String("Last parsed Amadeus file", required=True)
    parsed_at = sdk2.Attributes.String("Parsed at", required=False)
    last_parsed_resource_id = sdk2.Attributes.String("Last parsed resource id", required=False)


class AviaSharedFlightsLastUpdatedAmadeusTestingResource(AviaSharedFlightsLastUpdatedAmadeusResource):
    """ Attributes of the latest successful Amadeus parsing, testing environment """


class AviaSharedFlightsLastUpdatedAmadeusProductionResource(AviaSharedFlightsLastUpdatedAmadeusResource):
    """ Attributes of the latest successful Amadeus parsing, production environment """


class AviaSharedFlightsAmadeusResource(sdk2.Resource):
    """ Results of parsing the Amadeus files """
    releasers = ["avia"]
    releasable = True
    share = True  # Do share (create rbtorrent) resource
    auto_backup = True
    # common attributes
    restart_policy = ctr.RestartPolicy.DELETE  # drop the broken resource if task is restarted
    # custom attributes
    created_at = sdk2.Attributes.String("Created on this date", required=False)
    source_data_date = sdk2.Attributes.String("Based on the Amadeus data from this date", required=False)


class AviaSharedFlightsAmadeusTestingResource(AviaSharedFlightsAmadeusResource):
    """ The latest successfully parsed Amadeus data, testing environment """


class AviaSharedFlightsAmadeusProductionResource(AviaSharedFlightsAmadeusResource):
    """ The latest successfully parsed Amadeus data, production environment """
