from sandbox import sdk2
from sandbox.common.types import resource as ctr


class AviaSharedFlightsDiffBuilderSnapshotResource(sdk2.Resource):
    """ Dump of the year-long schedules snapshot """
    releasers = ["avia"]
    releasable = True
    share = True  # Do share (create rbtorrent) resource
    auto_backup = True
    # common attributes
    restart_policy = ctr.RestartPolicy.DELETE  # drop the broken resource if task is restarted


class AviaSharedFlightsDiffBuilderSnapshotTestingResource(AviaSharedFlightsDiffBuilderSnapshotResource):
    """ Dump of the year-long schedules for the testing environment"""


class AviaSharedFlightsDiffBuilderSnapshotProductionResource(AviaSharedFlightsDiffBuilderSnapshotResource):
    """ Dump of the year-long schedules for the production environment"""
