from sandbox import sdk2
from sandbox.common.types import resource as ctr


class AviaSharedFlightsFlyingTimeResource(sdk2.Resource):
    """ Dump of the minimal flying times between each and every pair of settlements """
    releasers = ["avia"]
    releasable = True
    share = True  # Do share (create rbtorrent) resource
    auto_backup = True
    # common attributes
    restart_policy = ctr.RestartPolicy.DELETE  # drop the broken resource if task is restarted


class AviaSharedFlightsFlyingTimeTestingResource(AviaSharedFlightsFlyingTimeResource):
    """ Dump of the minimal flying times for the testing environment"""


class AviaSharedFlightsFlyingTimeProductionResource(AviaSharedFlightsFlyingTimeResource):
    """ Dump of the minimal flying times for the production environment"""
