from sandbox import sdk2
from sandbox.common.types import resource as ctr


class AviaSharedFlightsQualityToolResource(sdk2.Resource):
    """ Results of parsing the sirena files """
    releasers = ["avia"]
    releasable = True
    share = True  # Do share (create rbtorrent) resource
    auto_backup = True
    # common attributes
    restart_policy = ctr.RestartPolicy.DELETE  # drop the broken resource if task is restarted


class AviaSharedFlightsQualityToolTestingResource(AviaSharedFlightsQualityToolResource):
    """ Results of comparing rasp and shared-flights data for the testing environment"""


class AviaSharedFlightsQualityToolProductionResource(AviaSharedFlightsQualityToolResource):
    """ Results of comparing rasp and shared-flights data for the production environment"""
