# -*- encoding: utf-8 -*-
import logging

import sandbox.common.types.misc as ctm
from sandbox import sdk2
from sandbox.projects.avia.base import AviaBaseTask
from sandbox.projects.common import binary_task
from sandbox.sandboxsdk.errors import SandboxTaskFailureError


class AviaSharedFlightsSchedulesDumperTask(binary_task.LastBinaryTaskRelease, AviaBaseTask):

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        ram = 8192

        class Caches(sdk2.Requirements.Caches):
            pass  # We do not need caches

        dns = ctm.DnsType.DNS64

    class Parameters(sdk2.Task.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)

        with sdk2.parameters.Group('Common settings') as common_settings:
            yt_token = sdk2.parameters.YavSecret(
                'Yav secret with YT token',
                required=True,
                default='sec-01dfxmszhq27tk66hm107d0ycd',
            )
            pg_password = sdk2.parameters.YavSecret(
                'Yav secret with PG password for flight storage',
                required=True,
                default='sec-01ejr2whpm3j9hscf7y6196gg2',
            )
            flight_date_from = sdk2.parameters.String(
                'Flight date from',
                required=True,
                default='',
            )
            flight_date_until = sdk2.parameters.String(
                'Flight date until',
                required=True,
                default='',
            )
            max_rows_per_select = sdk2.parameters.Integer(
                'Max row per select',
                required=False,
                default=0,
            )
            output_path = sdk2.parameters.String(
                'Output path at hahn',
                required=True,
                default_value='',
            )

    def on_prepare(self):
        self._logger = logging.getLogger(__name__)

        super(AviaSharedFlightsSchedulesDumperTask, self).on_prepare()

    def on_execute(self):
        from travel.avia.shared_flights.tasks.schedules_dumper.schedules_dumper import SchedulesDumper

        super(AviaSharedFlightsSchedulesDumperTask, self).on_execute()

        pg_password = self.Parameters.pg_password.data()['password']
        yt_token = self.Parameters.yt_token.data()['token']

        try:
            self._logger.info('Launching flight schedules dumper.')
            schedules_dumper = SchedulesDumper(
                self.Parameters.output_path,
                yt_token,
                pg_password,
                self.Parameters.max_rows_per_select,
            )
            schedules_dumper.run(
                self.Parameters.flight_date_from,
                self.Parameters.flight_date_until,
            )

            self._logger.info('Task has been completed.')
        except Exception as e:
            raise SandboxTaskFailureError('Unable to run schedules dumper. {}'.format(e))
