from sandbox import sdk2
from sandbox.common.types import resource as ctr


class AviaSharedFlightsSirenaResource(sdk2.Resource):
    """ Results of parsing the sirena files """
    releasers = ["avia"]
    releasable = True
    share = True  # Do share (create rbtorrent) resource
    auto_backup = True
    # common attributes
    restart_policy = ctr.RestartPolicy.DELETE  # drop the broken resource if task is restarted
    # custom attributes
    created_at = sdk2.Attributes.String("Created on this date", required=False)


class AviaSharedFlightsSirenaTestingResource(AviaSharedFlightsSirenaResource):
    """ Results of parsing files from Sirena for the testing environment"""


class AviaSharedFlightsSirenaProductionResource(AviaSharedFlightsSirenaResource):
    """ Results of parsing files from Sirena for the production environment"""
