from sandbox import sdk2
from sandbox.common.types import resource as ctr


class AviaSharedFlightsLastUpdatedResource(sdk2.Resource):
    """ Last innovata file processed by the shared flights parser """
    releasers = ["avia"]
    releasable = False
    share = False  # Do not share (create rbtorrent) resource
    auto_backup = True
    # common attributes
    restart_policy = ctr.RestartPolicy.IGNORE  # don't change the state
    # custom attributes
    last_parsed_date = sdk2.Attributes.String("Last parsed innovata file", required=True)
    parsed_at = sdk2.Attributes.String("Parsed at", required=False)
    last_parsed_resource_id = sdk2.Attributes.String("Last parsed resource id", required=False)


class AviaSharedFlightsLastUpdatedTestingResource(AviaSharedFlightsLastUpdatedResource):
    """ Attributes of the latest successful SSIM parsing, testing environment """


class AviaSharedFlightsLastUpdatedProductionResource(AviaSharedFlightsLastUpdatedResource):
    """ Attributes of the latest successful SSIM parsing, production environment """


class AviaSharedFlightsInnovataResource(sdk2.Resource):
    """ Results of parsing the innovata files """
    releasers = ["avia"]
    releasable = True
    share = True  # Do share (create rbtorrent) resource
    auto_backup = True
    # common attributes
    restart_policy = ctr.RestartPolicy.DELETE  # drop the broken resource if task is restarted
    # custom attributes
    created_at = sdk2.Attributes.String("Created on this date", required=False)
    source_data_date = sdk2.Attributes.String("Based on the innovata data from this date", required=False)


class AviaSharedFlightsInnovataTestingResource(AviaSharedFlightsInnovataResource):
    """ The latest successfully parsed SSIM data, testing environment """


class AviaSharedFlightsInnovataProductionResource(AviaSharedFlightsInnovataResource):
    """ The latest successfully parsed SSIM data, production environment """
