use `hahn`;

$prices = (
select
    substring(iso_eventtime, 0, 10) as `date`,
    transaction_id,
    CAST(_other["avia-our-price"] AS Double) AS avia_price,
    CAST(_other["avia-their-price"] AS Double) AS their_price,
    _other["domain"] AS domain
from range(
    '//logs/sovetnik-client-event-log/1d',
    '{left_date}',
    '{right_date}'
)
where event = 'avia-prices'
);

$Sign = ($x, $threshold) -> {{
    RETURN CASE
        WHEN abs($x) <= $threshold THEN 0
        WHEN $x < -1 * $threshold THEN -1
        WHEN $x > $threshold THEN 1
        ELSE 2
    END
}};

$by_transaction = (
select
    some(`date`) as `date`,
    SOME(domain) AS domain,
    MIN(their_price) AS their_price,
    MIN(avia_price) AS avia_price
from $prices
group by transaction_id
having MIN(their_price) is not null and min(avia_price) is not null
);

$stat = (
select
    domain,
    `date`,
    sign,
    COUNT(*) AS size
from $by_transaction
group by domain, `date`, $Sign(avia_price - their_price, 10) AS sign
);

$sums = (
    select domain, `date`, sum(size) as total_size from $stat group by domain, `date`
);

$ConvertSignToValue = ($sign) -> {{
    return case
        when $sign == 1 then 'their'
        when $sign == 0 then 'equal'
        else 'our'
    end;
}};


insert into
    {output_table}
with truncate
select
    stat.domain as domain,
    stat.`date` as fielddate,
    $ConvertSignToValue(sign) AS winner,
    size,
    cast(size as double) / sums.total_size As rel_size
    from $stat  As stat
inner join $sums as sums
using (domain, `date`);
