# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
import re
from sandbox import sdk2
from six import iteritems

log = logging.getLogger()


def resolve_args_secrets(run_args):
    return [resolve_secret_if_needed(argument) for argument in run_args]


def resolve_environment_secrets(environment):
    return {
        k: resolve_secret_if_needed(v)
        for k, v in iteritems(environment)
    }


def resolve_secret_if_needed(maybe_secret_id):
    if not string_is_a_secret_id(maybe_secret_id):
        return maybe_secret_id
    try:
        secret_value = sdk2.Vault.data(maybe_secret_id)
        log.info('secret with id {} is resolved'.format(maybe_secret_id))
        return secret_value
    except Exception:
        log.exception('Cannot resolve secret with id: %s', maybe_secret_id)
        return maybe_secret_id


def string_is_a_secret_id(maybe_secret_id):
    is_secret = re.match('^sec-.+(@ver-.+)?\[.+\]$', maybe_secret_id)
    if is_secret:
        log.info('string {} is a secret'.format(maybe_secret_id))
    else:
        log.info('string {} is not a secret'.format(maybe_secret_id))
    return is_secret


secrets_help = "Secrets in format sec-...[field] or sec-...@ver...[field] may be used as values"
