# coding: utf-8
from sandbox.projects.avia import verify_log
from sandbox import sdk2


class AviaVerifyJsonRedirLog(verify_log.AviaAbstractVerifyLogTask):
    _invalid_log_records_query = """ -- запрос для получения невалидных записей в логе
        DECLARE $table_path AS String;
        DECLARE $table_start_date AS String;
        DECLARE $table_finish_date AS String;

        SELECT
            *
        FROM
            range($table_path, $table_start_date, $table_finish_date)
        WHERE
            marker is NULL OR marker = ""
    """

    class Parameters(verify_log.AviaAbstractVerifyLogTask.Parameters):
        with sdk2.parameters.Group('Logs settings') as logs_settings:
            logs_path = sdk2.parameters.String(
                'Logs path',
                required=True,
                default='//logs/avia-json-redir-log/30min',
            )
